<?php

namespace PHPMaker2024\fibre;

use Psr\Container\ContainerInterface;
use Psr\Http\Message\ServerRequestInterface as Request;
use Psr\Http\Message\ResponseInterface as Response;
use PHPMaker2024\fibre\Attributes\Delete;
use PHPMaker2024\fibre\Attributes\Get;
use PHPMaker2024\fibre\Attributes\Map;
use PHPMaker2024\fibre\Attributes\Options;
use PHPMaker2024\fibre\Attributes\Patch;
use PHPMaker2024\fibre\Attributes\Post;
use PHPMaker2024\fibre\Attributes\Put;

class MgsCertificateDataController extends ControllerBase
{
    // list
    #[Map(["GET","POST","OPTIONS"], "/mgscertificatedatalist[/{id}]", [PermissionMiddleware::class], "list.mgs_certificate_data")]
    public function list(Request $request, Response $response, array $args): Response
    {
        return $this->runPage($request, $response, $args, "MgsCertificateDataList");
    }

    // add
    #[Map(["GET","POST","OPTIONS"], "/mgscertificatedataadd[/{id}]", [PermissionMiddleware::class], "add.mgs_certificate_data")]
    public function add(Request $request, Response $response, array $args): Response
    {
        return $this->runPage($request, $response, $args, "MgsCertificateDataAdd");
    }

    // edit
    #[Map(["GET","POST","OPTIONS"], "/mgscertificatedataedit[/{id}]", [PermissionMiddleware::class], "edit.mgs_certificate_data")]
    public function edit(Request $request, Response $response, array $args): Response
    {
        return $this->runPage($request, $response, $args, "MgsCertificateDataEdit");
    }

    // search
    #[Map(["GET","POST","OPTIONS"], "/mgscertificatedatasearch", [PermissionMiddleware::class], "search.mgs_certificate_data")]
    public function search(Request $request, Response $response, array $args): Response
    {
        return $this->runPage($request, $response, $args, "MgsCertificateDataSearch");
    }
}
