<?php

namespace PHPMaker2024\fibre;

use Psr\Container\ContainerInterface;
use Psr\Http\Message\ServerRequestInterface as Request;
use Psr\Http\Message\ResponseInterface as Response;
use PHPMaker2024\fibre\Attributes\Delete;
use PHPMaker2024\fibre\Attributes\Get;
use PHPMaker2024\fibre\Attributes\Map;
use PHPMaker2024\fibre\Attributes\Options;
use PHPMaker2024\fibre\Attributes\Patch;
use PHPMaker2024\fibre\Attributes\Post;
use PHPMaker2024\fibre\Attributes\Put;

class MgsCertificateController extends ControllerBase
{
    // list
    #[Map(["GET","POST","OPTIONS"], "/mgscertificatelist[/{id}]", [PermissionMiddleware::class], "list.mgs_certificate")]
    public function list(Request $request, Response $response, array $args): Response
    {
        return $this->runPage($request, $response, $args, "MgsCertificateList");
    }

    // add
    #[Map(["GET","POST","OPTIONS"], "/mgscertificateadd[/{id}]", [PermissionMiddleware::class], "add.mgs_certificate")]
    public function add(Request $request, Response $response, array $args): Response
    {
        return $this->runPage($request, $response, $args, "MgsCertificateAdd");
    }

    // view
    #[Map(["GET","POST","OPTIONS"], "/mgscertificateview[/{id}]", [PermissionMiddleware::class], "view.mgs_certificate")]
    public function view(Request $request, Response $response, array $args): Response
    {
        return $this->runPage($request, $response, $args, "MgsCertificateView");
    }

    // edit
    #[Map(["GET","POST","OPTIONS"], "/mgscertificateedit[/{id}]", [PermissionMiddleware::class], "edit.mgs_certificate")]
    public function edit(Request $request, Response $response, array $args): Response
    {
        return $this->runPage($request, $response, $args, "MgsCertificateEdit");
    }

    // delete
    #[Map(["GET","POST","OPTIONS"], "/mgscertificatedelete[/{id}]", [PermissionMiddleware::class], "delete.mgs_certificate")]
    public function delete(Request $request, Response $response, array $args): Response
    {
        return $this->runPage($request, $response, $args, "MgsCertificateDelete");
    }
}
