<?php

namespace PHPMaker2024\fibre;

use Psr\Container\ContainerInterface;
use Psr\Http\Message\ServerRequestInterface as Request;
use Psr\Http\Message\ResponseInterface as Response;
use PHPMaker2024\fibre\Attributes\Delete;
use PHPMaker2024\fibre\Attributes\Get;
use PHPMaker2024\fibre\Attributes\Map;
use PHPMaker2024\fibre\Attributes\Options;
use PHPMaker2024\fibre\Attributes\Patch;
use PHPMaker2024\fibre\Attributes\Post;
use PHPMaker2024\fibre\Attributes\Put;

class MethodController extends ControllerBase
{
    // list
    #[Map(["GET","POST","OPTIONS"], "/methodlist[/{id}]", [PermissionMiddleware::class], "list.method")]
    public function list(Request $request, Response $response, array $args): Response
    {
        return $this->runPage($request, $response, $args, "MethodList");
    }

    // add
    #[Map(["GET","POST","OPTIONS"], "/methodadd[/{id}]", [PermissionMiddleware::class], "add.method")]
    public function add(Request $request, Response $response, array $args): Response
    {
        return $this->runPage($request, $response, $args, "MethodAdd");
    }

    // view
    #[Map(["GET","POST","OPTIONS"], "/methodview[/{id}]", [PermissionMiddleware::class], "view.method")]
    public function view(Request $request, Response $response, array $args): Response
    {
        return $this->runPage($request, $response, $args, "MethodView");
    }

    // edit
    #[Map(["GET","POST","OPTIONS"], "/methodedit[/{id}]", [PermissionMiddleware::class], "edit.method")]
    public function edit(Request $request, Response $response, array $args): Response
    {
        return $this->runPage($request, $response, $args, "MethodEdit");
    }

    // delete
    #[Map(["GET","POST","OPTIONS"], "/methoddelete[/{id}]", [PermissionMiddleware::class], "delete.method")]
    public function delete(Request $request, Response $response, array $args): Response
    {
        return $this->runPage($request, $response, $args, "MethodDelete");
    }
}
