<?php

namespace PHPMaker2024\fibre;

use Psr\Container\ContainerInterface;
use Psr\Http\Message\ServerRequestInterface as Request;
use Psr\Http\Message\ResponseInterface as Response;
use PHPMaker2024\fibre\Attributes\Delete;
use PHPMaker2024\fibre\Attributes\Get;
use PHPMaker2024\fibre\Attributes\Map;
use PHPMaker2024\fibre\Attributes\Options;
use PHPMaker2024\fibre\Attributes\Patch;
use PHPMaker2024\fibre\Attributes\Post;
use PHPMaker2024\fibre\Attributes\Put;

class MessageTypeController extends ControllerBase
{
    // list
    #[Map(["GET","POST","OPTIONS"], "/messagetypelist[/{id}]", [PermissionMiddleware::class], "list.message_type")]
    public function list(Request $request, Response $response, array $args): Response
    {
        return $this->runPage($request, $response, $args, "MessageTypeList");
    }

    // add
    #[Map(["GET","POST","OPTIONS"], "/messagetypeadd[/{id}]", [PermissionMiddleware::class], "add.message_type")]
    public function add(Request $request, Response $response, array $args): Response
    {
        return $this->runPage($request, $response, $args, "MessageTypeAdd");
    }

    // view
    #[Map(["GET","POST","OPTIONS"], "/messagetypeview[/{id}]", [PermissionMiddleware::class], "view.message_type")]
    public function view(Request $request, Response $response, array $args): Response
    {
        return $this->runPage($request, $response, $args, "MessageTypeView");
    }

    // edit
    #[Map(["GET","POST","OPTIONS"], "/messagetypeedit[/{id}]", [PermissionMiddleware::class], "edit.message_type")]
    public function edit(Request $request, Response $response, array $args): Response
    {
        return $this->runPage($request, $response, $args, "MessageTypeEdit");
    }

    // delete
    #[Map(["GET","POST","OPTIONS"], "/messagetypedelete[/{id}]", [PermissionMiddleware::class], "delete.message_type")]
    public function delete(Request $request, Response $response, array $args): Response
    {
        return $this->runPage($request, $response, $args, "MessageTypeDelete");
    }
}
