<?php

namespace PHPMaker2024\fibre;

use Psr\Container\ContainerInterface;
use Psr\Http\Message\ServerRequestInterface as Request;
use Psr\Http\Message\ResponseInterface as Response;
use PHPMaker2024\fibre\Attributes\Delete;
use PHPMaker2024\fibre\Attributes\Get;
use PHPMaker2024\fibre\Attributes\Map;
use PHPMaker2024\fibre\Attributes\Options;
use PHPMaker2024\fibre\Attributes\Patch;
use PHPMaker2024\fibre\Attributes\Post;
use PHPMaker2024\fibre\Attributes\Put;

class MessageTemplateOfficeController extends ControllerBase
{
    // list
    #[Map(["GET","POST","OPTIONS"], "/messagetemplateofficelist[/{id}]", [PermissionMiddleware::class], "list.message_template_office")]
    public function list(Request $request, Response $response, array $args): Response
    {
        return $this->runPage($request, $response, $args, "MessageTemplateOfficeList");
    }

    // add
    #[Map(["GET","POST","OPTIONS"], "/messagetemplateofficeadd[/{id}]", [PermissionMiddleware::class], "add.message_template_office")]
    public function add(Request $request, Response $response, array $args): Response
    {
        return $this->runPage($request, $response, $args, "MessageTemplateOfficeAdd");
    }

    // view
    #[Map(["GET","POST","OPTIONS"], "/messagetemplateofficeview[/{id}]", [PermissionMiddleware::class], "view.message_template_office")]
    public function view(Request $request, Response $response, array $args): Response
    {
        return $this->runPage($request, $response, $args, "MessageTemplateOfficeView");
    }

    // edit
    #[Map(["GET","POST","OPTIONS"], "/messagetemplateofficeedit[/{id}]", [PermissionMiddleware::class], "edit.message_template_office")]
    public function edit(Request $request, Response $response, array $args): Response
    {
        return $this->runPage($request, $response, $args, "MessageTemplateOfficeEdit");
    }
}
