<?php

namespace PHPMaker2024\fibre;

use Psr\Container\ContainerInterface;
use Psr\Http\Message\ServerRequestInterface as Request;
use Psr\Http\Message\ResponseInterface as Response;
use PHPMaker2024\fibre\Attributes\Delete;
use PHPMaker2024\fibre\Attributes\Get;
use PHPMaker2024\fibre\Attributes\Map;
use PHPMaker2024\fibre\Attributes\Options;
use PHPMaker2024\fibre\Attributes\Patch;
use PHPMaker2024\fibre\Attributes\Post;
use PHPMaker2024\fibre\Attributes\Put;

class MessageTemplateAdminController extends ControllerBase
{
    // list
    #[Map(["GET","POST","OPTIONS"], "/messagetemplateadminlist[/{id}]", [PermissionMiddleware::class], "list.message_template_admin")]
    public function list(Request $request, Response $response, array $args): Response
    {
        return $this->runPage($request, $response, $args, "MessageTemplateAdminList");
    }

    // add
    #[Map(["GET","POST","OPTIONS"], "/messagetemplateadminadd[/{id}]", [PermissionMiddleware::class], "add.message_template_admin")]
    public function add(Request $request, Response $response, array $args): Response
    {
        return $this->runPage($request, $response, $args, "MessageTemplateAdminAdd");
    }

    // view
    #[Map(["GET","POST","OPTIONS"], "/messagetemplateadminview[/{id}]", [PermissionMiddleware::class], "view.message_template_admin")]
    public function view(Request $request, Response $response, array $args): Response
    {
        return $this->runPage($request, $response, $args, "MessageTemplateAdminView");
    }

    // edit
    #[Map(["GET","POST","OPTIONS"], "/messagetemplateadminedit[/{id}]", [PermissionMiddleware::class], "edit.message_template_admin")]
    public function edit(Request $request, Response $response, array $args): Response
    {
        return $this->runPage($request, $response, $args, "MessageTemplateAdminEdit");
    }

    // delete
    #[Map(["GET","POST","OPTIONS"], "/messagetemplateadmindelete[/{id}]", [PermissionMiddleware::class], "delete.message_template_admin")]
    public function delete(Request $request, Response $response, array $args): Response
    {
        return $this->runPage($request, $response, $args, "MessageTemplateAdminDelete");
    }

    // search
    #[Map(["GET","POST","OPTIONS"], "/messagetemplateadminsearch", [PermissionMiddleware::class], "search.message_template_admin")]
    public function search(Request $request, Response $response, array $args): Response
    {
        return $this->runPage($request, $response, $args, "MessageTemplateAdminSearch");
    }
}
