<?php

namespace PHPMaker2024\fibre;

use Psr\Container\ContainerInterface;
use Psr\Http\Message\ServerRequestInterface as Request;
use Psr\Http\Message\ResponseInterface as Response;
use PHPMaker2024\fibre\Attributes\Delete;
use PHPMaker2024\fibre\Attributes\Get;
use PHPMaker2024\fibre\Attributes\Map;
use PHPMaker2024\fibre\Attributes\Options;
use PHPMaker2024\fibre\Attributes\Patch;
use PHPMaker2024\fibre\Attributes\Post;
use PHPMaker2024\fibre\Attributes\Put;

class MenusController extends ControllerBase
{
    // list
    #[Map(["GET","POST","OPTIONS"], "/menuslist[/{id}]", [PermissionMiddleware::class], "list.menus")]
    public function list(Request $request, Response $response, array $args): Response
    {
        return $this->runPage($request, $response, $args, "MenusList");
    }

    // add
    #[Map(["GET","POST","OPTIONS"], "/menusadd[/{id}]", [PermissionMiddleware::class], "add.menus")]
    public function add(Request $request, Response $response, array $args): Response
    {
        return $this->runPage($request, $response, $args, "MenusAdd");
    }

    // view
    #[Map(["GET","POST","OPTIONS"], "/menusview[/{id}]", [PermissionMiddleware::class], "view.menus")]
    public function view(Request $request, Response $response, array $args): Response
    {
        return $this->runPage($request, $response, $args, "MenusView");
    }

    // edit
    #[Map(["GET","POST","OPTIONS"], "/menusedit[/{id}]", [PermissionMiddleware::class], "edit.menus")]
    public function edit(Request $request, Response $response, array $args): Response
    {
        return $this->runPage($request, $response, $args, "MenusEdit");
    }

    // delete
    #[Map(["GET","POST","OPTIONS"], "/menusdelete[/{id}]", [PermissionMiddleware::class], "delete.menus")]
    public function delete(Request $request, Response $response, array $args): Response
    {
        return $this->runPage($request, $response, $args, "MenusDelete");
    }

    // search
    #[Map(["GET","POST","OPTIONS"], "/menussearch", [PermissionMiddleware::class], "search.menus")]
    public function search(Request $request, Response $response, array $args): Response
    {
        return $this->runPage($request, $response, $args, "MenusSearch");
    }
}
