<?php

namespace PHPMaker2024\fibre;

use Psr\Container\ContainerInterface;
use Psr\Http\Message\ServerRequestInterface as Request;
use Psr\Http\Message\ResponseInterface as Response;
use PHPMaker2024\fibre\Attributes\Delete;
use PHPMaker2024\fibre\Attributes\Get;
use PHPMaker2024\fibre\Attributes\Map;
use PHPMaker2024\fibre\Attributes\Options;
use PHPMaker2024\fibre\Attributes\Patch;
use PHPMaker2024\fibre\Attributes\Post;
use PHPMaker2024\fibre\Attributes\Put;

class MemberInfoController extends ControllerBase
{
    // list
    #[Map(["GET","POST","OPTIONS"], "/memberinfolist[/{id}]", [PermissionMiddleware::class], "list.member_info")]
    public function list(Request $request, Response $response, array $args): Response
    {
        return $this->runPage($request, $response, $args, "MemberInfoList");
    }

    // add
    #[Map(["GET","POST","OPTIONS"], "/memberinfoadd[/{id}]", [PermissionMiddleware::class], "add.member_info")]
    public function add(Request $request, Response $response, array $args): Response
    {
        return $this->runPage($request, $response, $args, "MemberInfoAdd");
    }

    // view
    #[Map(["GET","POST","OPTIONS"], "/memberinfoview[/{id}]", [PermissionMiddleware::class], "view.member_info")]
    public function view(Request $request, Response $response, array $args): Response
    {
        return $this->runPage($request, $response, $args, "MemberInfoView");
    }

    // edit
    #[Map(["GET","POST","OPTIONS"], "/memberinfoedit[/{id}]", [PermissionMiddleware::class], "edit.member_info")]
    public function edit(Request $request, Response $response, array $args): Response
    {
        return $this->runPage($request, $response, $args, "MemberInfoEdit");
    }

    // delete
    #[Map(["GET","POST","OPTIONS"], "/memberinfodelete[/{id}]", [PermissionMiddleware::class], "delete.member_info")]
    public function delete(Request $request, Response $response, array $args): Response
    {
        return $this->runPage($request, $response, $args, "MemberInfoDelete");
    }

    // search
    #[Map(["GET","POST","OPTIONS"], "/memberinfosearch", [PermissionMiddleware::class], "search.member_info")]
    public function search(Request $request, Response $response, array $args): Response
    {
        return $this->runPage($request, $response, $args, "MemberInfoSearch");
    }
}
