<?php

namespace PHPMaker2024\fibre;

use Psr\Container\ContainerInterface;
use Psr\Http\Message\ServerRequestInterface as Request;
use Psr\Http\Message\ResponseInterface as Response;
use PHPMaker2024\fibre\Attributes\Delete;
use PHPMaker2024\fibre\Attributes\Get;
use PHPMaker2024\fibre\Attributes\Map;
use PHPMaker2024\fibre\Attributes\Options;
use PHPMaker2024\fibre\Attributes\Patch;
use PHPMaker2024\fibre\Attributes\Post;
use PHPMaker2024\fibre\Attributes\Put;

class MaterialStatusController extends ControllerBase
{
    // list
    #[Map(["GET","POST","OPTIONS"], "/materialstatuslist[/{id}]", [PermissionMiddleware::class], "list.material_status")]
    public function list(Request $request, Response $response, array $args): Response
    {
        return $this->runPage($request, $response, $args, "MaterialStatusList");
    }

    // view
    #[Map(["GET","POST","OPTIONS"], "/materialstatusview[/{id}]", [PermissionMiddleware::class], "view.material_status")]
    public function view(Request $request, Response $response, array $args): Response
    {
        return $this->runPage($request, $response, $args, "MaterialStatusView");
    }

    // search
    #[Map(["GET","POST","OPTIONS"], "/materialstatussearch", [PermissionMiddleware::class], "search.material_status")]
    public function search(Request $request, Response $response, array $args): Response
    {
        return $this->runPage($request, $response, $args, "MaterialStatusSearch");
    }
}
