<?php

namespace PHPMaker2024\fibre;

use Psr\Container\ContainerInterface;
use Psr\Http\Message\ServerRequestInterface as Request;
use Psr\Http\Message\ResponseInterface as Response;
use PHPMaker2024\fibre\Attributes\Delete;
use PHPMaker2024\fibre\Attributes\Get;
use PHPMaker2024\fibre\Attributes\Map;
use PHPMaker2024\fibre\Attributes\Options;
use PHPMaker2024\fibre\Attributes\Patch;
use PHPMaker2024\fibre\Attributes\Post;
use PHPMaker2024\fibre\Attributes\Put;

class MaterialRequiredWeeklyLoomplanController extends ControllerBase
{
    // list
    #[Map(["GET","POST","OPTIONS"], "/materialrequiredweeklyloomplanlist", [PermissionMiddleware::class], "list.material_required_weekly_loomplan")]
    public function list(Request $request, Response $response, array $args): Response
    {
        return $this->runPage($request, $response, $args, "MaterialRequiredWeeklyLoomplanList");
    }

    // search
    #[Map(["GET","POST","OPTIONS"], "/materialrequiredweeklyloomplansearch", [PermissionMiddleware::class], "search.material_required_weekly_loomplan")]
    public function search(Request $request, Response $response, array $args): Response
    {
        return $this->runPage($request, $response, $args, "MaterialRequiredWeeklyLoomplanSearch");
    }

    // preview
    #[Map(["GET","OPTIONS"], "/materialrequiredweeklyloomplanpreview", [PermissionMiddleware::class], "preview.material_required_weekly_loomplan")]
    public function preview(Request $request, Response $response, array $args): Response
    {
        return $this->runPage($request, $response, $args, "MaterialRequiredWeeklyLoomplanPreview", null, false);
    }
}
