<?php

namespace PHPMaker2024\fibre;

use Psr\Container\ContainerInterface;
use Psr\Http\Message\ServerRequestInterface as Request;
use Psr\Http\Message\ResponseInterface as Response;
use PHPMaker2024\fibre\Attributes\Delete;
use PHPMaker2024\fibre\Attributes\Get;
use PHPMaker2024\fibre\Attributes\Map;
use PHPMaker2024\fibre\Attributes\Options;
use PHPMaker2024\fibre\Attributes\Patch;
use PHPMaker2024\fibre\Attributes\Post;
use PHPMaker2024\fibre\Attributes\Put;

class MaterialRequiredProcessingOutsideOldController extends ControllerBase
{
    // list
    #[Map(["GET","POST","OPTIONS"], "/materialrequiredprocessingoutsideoldlist[/{id}]", [PermissionMiddleware::class], "list.material_required_processing_outside_old")]
    public function list(Request $request, Response $response, array $args): Response
    {
        return $this->runPage($request, $response, $args, "MaterialRequiredProcessingOutsideOldList");
    }

    // view
    #[Map(["GET","POST","OPTIONS"], "/materialrequiredprocessingoutsideoldview[/{id}]", [PermissionMiddleware::class], "view.material_required_processing_outside_old")]
    public function view(Request $request, Response $response, array $args): Response
    {
        return $this->runPage($request, $response, $args, "MaterialRequiredProcessingOutsideOldView");
    }

    // search
    #[Map(["GET","POST","OPTIONS"], "/materialrequiredprocessingoutsideoldsearch", [PermissionMiddleware::class], "search.material_required_processing_outside_old")]
    public function search(Request $request, Response $response, array $args): Response
    {
        return $this->runPage($request, $response, $args, "MaterialRequiredProcessingOutsideOldSearch");
    }
}
