<?php

namespace PHPMaker2024\fibre;

use Psr\Container\ContainerInterface;
use Psr\Http\Message\ServerRequestInterface as Request;
use Psr\Http\Message\ResponseInterface as Response;
use PHPMaker2024\fibre\Attributes\Delete;
use PHPMaker2024\fibre\Attributes\Get;
use PHPMaker2024\fibre\Attributes\Map;
use PHPMaker2024\fibre\Attributes\Options;
use PHPMaker2024\fibre\Attributes\Patch;
use PHPMaker2024\fibre\Attributes\Post;
use PHPMaker2024\fibre\Attributes\Put;

class MaterialRequiredLiveController extends ControllerBase
{
    // list
    #[Map(["GET","POST","OPTIONS"], "/materialrequiredlivelist[/{id}]", [PermissionMiddleware::class], "list.material_required_live")]
    public function list(Request $request, Response $response, array $args): Response
    {
        return $this->runPage($request, $response, $args, "MaterialRequiredLiveList");
    }

    // view
    #[Map(["GET","POST","OPTIONS"], "/materialrequiredliveview[/{id}]", [PermissionMiddleware::class], "view.material_required_live")]
    public function view(Request $request, Response $response, array $args): Response
    {
        return $this->runPage($request, $response, $args, "MaterialRequiredLiveView");
    }

    // edit
    #[Map(["GET","POST","OPTIONS"], "/materialrequiredliveedit[/{id}]", [PermissionMiddleware::class], "edit.material_required_live")]
    public function edit(Request $request, Response $response, array $args): Response
    {
        return $this->runPage($request, $response, $args, "MaterialRequiredLiveEdit");
    }

    // search
    #[Map(["GET","POST","OPTIONS"], "/materialrequiredlivesearch", [PermissionMiddleware::class], "search.material_required_live")]
    public function search(Request $request, Response $response, array $args): Response
    {
        return $this->runPage($request, $response, $args, "MaterialRequiredLiveSearch");
    }

    // preview
    #[Map(["GET","OPTIONS"], "/materialrequiredlivepreview", [PermissionMiddleware::class], "preview.material_required_live")]
    public function preview(Request $request, Response $response, array $args): Response
    {
        return $this->runPage($request, $response, $args, "MaterialRequiredLivePreview", null, false);
    }
}
