<?php

namespace PHPMaker2024\fibre;

use Psr\Container\ContainerInterface;
use Psr\Http\Message\ServerRequestInterface as Request;
use Psr\Http\Message\ResponseInterface as Response;
use PHPMaker2024\fibre\Attributes\Delete;
use PHPMaker2024\fibre\Attributes\Get;
use PHPMaker2024\fibre\Attributes\Map;
use PHPMaker2024\fibre\Attributes\Options;
use PHPMaker2024\fibre\Attributes\Patch;
use PHPMaker2024\fibre\Attributes\Post;
use PHPMaker2024\fibre\Attributes\Put;

class MaterialRequiredJobCardController extends ControllerBase
{
    // list
    #[Map(["GET","POST","OPTIONS"], "/materialrequiredjobcardlist[/{id}]", [PermissionMiddleware::class], "list.material_required_job_card")]
    public function list(Request $request, Response $response, array $args): Response
    {
        return $this->runPage($request, $response, $args, "MaterialRequiredJobCardList");
    }

    // add
    #[Map(["GET","POST","OPTIONS"], "/materialrequiredjobcardadd[/{id}]", [PermissionMiddleware::class], "add.material_required_job_card")]
    public function add(Request $request, Response $response, array $args): Response
    {
        return $this->runPage($request, $response, $args, "MaterialRequiredJobCardAdd");
    }

    // view
    #[Map(["GET","POST","OPTIONS"], "/materialrequiredjobcardview[/{id}]", [PermissionMiddleware::class], "view.material_required_job_card")]
    public function view(Request $request, Response $response, array $args): Response
    {
        return $this->runPage($request, $response, $args, "MaterialRequiredJobCardView");
    }

    // edit
    #[Map(["GET","POST","OPTIONS"], "/materialrequiredjobcardedit[/{id}]", [PermissionMiddleware::class], "edit.material_required_job_card")]
    public function edit(Request $request, Response $response, array $args): Response
    {
        return $this->runPage($request, $response, $args, "MaterialRequiredJobCardEdit");
    }

    // delete
    #[Map(["GET","POST","OPTIONS"], "/materialrequiredjobcarddelete[/{id}]", [PermissionMiddleware::class], "delete.material_required_job_card")]
    public function delete(Request $request, Response $response, array $args): Response
    {
        return $this->runPage($request, $response, $args, "MaterialRequiredJobCardDelete");
    }
}
