<?php

namespace PHPMaker2024\fibre;

use Psr\Container\ContainerInterface;
use Psr\Http\Message\ServerRequestInterface as Request;
use Psr\Http\Message\ResponseInterface as Response;
use PHPMaker2024\fibre\Attributes\Delete;
use PHPMaker2024\fibre\Attributes\Get;
use PHPMaker2024\fibre\Attributes\Map;
use PHPMaker2024\fibre\Attributes\Options;
use PHPMaker2024\fibre\Attributes\Patch;
use PHPMaker2024\fibre\Attributes\Post;
use PHPMaker2024\fibre\Attributes\Put;

class MaterialRequiredController extends ControllerBase
{
    // list
    #[Map(["GET","POST","OPTIONS"], "/materialrequiredlist[/{id}]", [PermissionMiddleware::class], "list.material_required")]
    public function list(Request $request, Response $response, array $args): Response
    {
        return $this->runPage($request, $response, $args, "MaterialRequiredList");
    }

    // edit
    #[Map(["GET","POST","OPTIONS"], "/materialrequirededit[/{id}]", [PermissionMiddleware::class], "edit.material_required")]
    public function edit(Request $request, Response $response, array $args): Response
    {
        return $this->runPage($request, $response, $args, "MaterialRequiredEdit");
    }

    // preview
    #[Map(["GET","OPTIONS"], "/materialrequiredpreview", [PermissionMiddleware::class], "preview.material_required")]
    public function preview(Request $request, Response $response, array $args): Response
    {
        return $this->runPage($request, $response, $args, "MaterialRequiredPreview", null, false);
    }
}
