<?php

namespace PHPMaker2024\fibre;

use Psr\Container\ContainerInterface;
use Psr\Http\Message\ServerRequestInterface as Request;
use Psr\Http\Message\ResponseInterface as Response;
use PHPMaker2024\fibre\Attributes\Delete;
use PHPMaker2024\fibre\Attributes\Get;
use PHPMaker2024\fibre\Attributes\Map;
use PHPMaker2024\fibre\Attributes\Options;
use PHPMaker2024\fibre\Attributes\Patch;
use PHPMaker2024\fibre\Attributes\Post;
use PHPMaker2024\fibre\Attributes\Put;

class MaterialOutWbcController extends ControllerBase
{
    // list
    #[Map(["GET","POST","OPTIONS"], "/materialoutwbclist[/{id}]", [PermissionMiddleware::class], "list.material_out_wbc")]
    public function list(Request $request, Response $response, array $args): Response
    {
        return $this->runPage($request, $response, $args, "MaterialOutWbcList");
    }

    // add
    #[Map(["GET","POST","OPTIONS"], "/materialoutwbcadd[/{id}]", [PermissionMiddleware::class], "add.material_out_wbc")]
    public function add(Request $request, Response $response, array $args): Response
    {
        return $this->runPage($request, $response, $args, "MaterialOutWbcAdd");
    }

    // addopt
    #[Map(["GET","POST","OPTIONS"], "/materialoutwbcaddopt", [PermissionMiddleware::class], "addopt.material_out_wbc")]
    public function addopt(Request $request, Response $response, array $args): Response
    {
        return $this->runPage($request, $response, $args, "MaterialOutWbcAddopt", null, false);
    }

    // view
    #[Map(["GET","POST","OPTIONS"], "/materialoutwbcview[/{id}]", [PermissionMiddleware::class], "view.material_out_wbc")]
    public function view(Request $request, Response $response, array $args): Response
    {
        return $this->runPage($request, $response, $args, "MaterialOutWbcView");
    }

    // edit
    #[Map(["GET","POST","OPTIONS"], "/materialoutwbcedit[/{id}]", [PermissionMiddleware::class], "edit.material_out_wbc")]
    public function edit(Request $request, Response $response, array $args): Response
    {
        return $this->runPage($request, $response, $args, "MaterialOutWbcEdit");
    }

    // delete
    #[Map(["GET","POST","OPTIONS"], "/materialoutwbcdelete[/{id}]", [PermissionMiddleware::class], "delete.material_out_wbc")]
    public function delete(Request $request, Response $response, array $args): Response
    {
        return $this->runPage($request, $response, $args, "MaterialOutWbcDelete");
    }

    // search
    #[Map(["GET","POST","OPTIONS"], "/materialoutwbcsearch", [PermissionMiddleware::class], "search.material_out_wbc")]
    public function search(Request $request, Response $response, array $args): Response
    {
        return $this->runPage($request, $response, $args, "MaterialOutWbcSearch");
    }
}
