<?php

namespace PHPMaker2024\fibre;

use Psr\Container\ContainerInterface;
use Psr\Http\Message\ServerRequestInterface as Request;
use Psr\Http\Message\ResponseInterface as Response;
use PHPMaker2024\fibre\Attributes\Delete;
use PHPMaker2024\fibre\Attributes\Get;
use PHPMaker2024\fibre\Attributes\Map;
use PHPMaker2024\fibre\Attributes\Options;
use PHPMaker2024\fibre\Attributes\Patch;
use PHPMaker2024\fibre\Attributes\Post;
use PHPMaker2024\fibre\Attributes\Put;

class MaterialOutPoController extends ControllerBase
{
    // list
    #[Map(["GET","POST","OPTIONS"], "/materialoutpolist[/{id}]", [PermissionMiddleware::class], "list.material_out_po")]
    public function list(Request $request, Response $response, array $args): Response
    {
        return $this->runPage($request, $response, $args, "MaterialOutPoList");
    }

    // add
    #[Map(["GET","POST","OPTIONS"], "/materialoutpoadd[/{id}]", [PermissionMiddleware::class], "add.material_out_po")]
    public function add(Request $request, Response $response, array $args): Response
    {
        return $this->runPage($request, $response, $args, "MaterialOutPoAdd");
    }

    // view
    #[Map(["GET","POST","OPTIONS"], "/materialoutpoview[/{id}]", [PermissionMiddleware::class], "view.material_out_po")]
    public function view(Request $request, Response $response, array $args): Response
    {
        return $this->runPage($request, $response, $args, "MaterialOutPoView");
    }

    // search
    #[Map(["GET","POST","OPTIONS"], "/materialoutposearch", [PermissionMiddleware::class], "search.material_out_po")]
    public function search(Request $request, Response $response, array $args): Response
    {
        return $this->runPage($request, $response, $args, "MaterialOutPoSearch");
    }
}
