<?php

namespace PHPMaker2024\fibre;

use Psr\Container\ContainerInterface;
use Psr\Http\Message\ServerRequestInterface as Request;
use Psr\Http\Message\ResponseInterface as Response;
use PHPMaker2024\fibre\Attributes\Delete;
use PHPMaker2024\fibre\Attributes\Get;
use PHPMaker2024\fibre\Attributes\Map;
use PHPMaker2024\fibre\Attributes\Options;
use PHPMaker2024\fibre\Attributes\Patch;
use PHPMaker2024\fibre\Attributes\Post;
use PHPMaker2024\fibre\Attributes\Put;

class MaterialOutController extends ControllerBase
{
    // list
    #[Map(["GET","POST","OPTIONS"], "/materialoutlist[/{id}]", [PermissionMiddleware::class], "list.material_out")]
    public function list(Request $request, Response $response, array $args): Response
    {
        return $this->runPage($request, $response, $args, "MaterialOutList");
    }

    // add
    #[Map(["GET","POST","OPTIONS"], "/materialoutadd[/{id}]", [PermissionMiddleware::class], "add.material_out")]
    public function add(Request $request, Response $response, array $args): Response
    {
        return $this->runPage($request, $response, $args, "MaterialOutAdd");
    }

    // view
    #[Map(["GET","POST","OPTIONS"], "/materialoutview[/{id}]", [PermissionMiddleware::class], "view.material_out")]
    public function view(Request $request, Response $response, array $args): Response
    {
        return $this->runPage($request, $response, $args, "MaterialOutView");
    }

    // edit
    #[Map(["GET","POST","OPTIONS"], "/materialoutedit[/{id}]", [PermissionMiddleware::class], "edit.material_out")]
    public function edit(Request $request, Response $response, array $args): Response
    {
        return $this->runPage($request, $response, $args, "MaterialOutEdit");
    }

    // search
    #[Map(["GET","POST","OPTIONS"], "/materialoutsearch", [PermissionMiddleware::class], "search.material_out")]
    public function search(Request $request, Response $response, array $args): Response
    {
        return $this->runPage($request, $response, $args, "MaterialOutSearch");
    }
}
