<?php

namespace PHPMaker2024\fibre;

use Psr\Container\ContainerInterface;
use Psr\Http\Message\ServerRequestInterface as Request;
use Psr\Http\Message\ResponseInterface as Response;
use PHPMaker2024\fibre\Attributes\Delete;
use PHPMaker2024\fibre\Attributes\Get;
use PHPMaker2024\fibre\Attributes\Map;
use PHPMaker2024\fibre\Attributes\Options;
use PHPMaker2024\fibre\Attributes\Patch;
use PHPMaker2024\fibre\Attributes\Post;
use PHPMaker2024\fibre\Attributes\Put;

class MaterialOutBcController extends ControllerBase
{
    // list
    #[Map(["GET","POST","OPTIONS"], "/materialoutbclist", [PermissionMiddleware::class], "list.material_out_bc")]
    public function list(Request $request, Response $response, array $args): Response
    {
        return $this->runPage($request, $response, $args, "MaterialOutBcList");
    }

    // add
    #[Map(["GET","POST","OPTIONS"], "/materialoutbcadd", [PermissionMiddleware::class], "add.material_out_bc")]
    public function add(Request $request, Response $response, array $args): Response
    {
        return $this->runPage($request, $response, $args, "MaterialOutBcAdd");
    }

    // search
    #[Map(["GET","POST","OPTIONS"], "/materialoutbcsearch", [PermissionMiddleware::class], "search.material_out_bc")]
    public function search(Request $request, Response $response, array $args): Response
    {
        return $this->runPage($request, $response, $args, "MaterialOutBcSearch");
    }
}
