<?php

namespace PHPMaker2024\fibre;

use Psr\Container\ContainerInterface;
use Psr\Http\Message\ServerRequestInterface as Request;
use Psr\Http\Message\ResponseInterface as Response;
use PHPMaker2024\fibre\Attributes\Delete;
use PHPMaker2024\fibre\Attributes\Get;
use PHPMaker2024\fibre\Attributes\Map;
use PHPMaker2024\fibre\Attributes\Options;
use PHPMaker2024\fibre\Attributes\Patch;
use PHPMaker2024\fibre\Attributes\Post;
use PHPMaker2024\fibre\Attributes\Put;

class MaterialOrderController extends ControllerBase
{
    // list
    #[Map(["GET","POST","OPTIONS"], "/materialorderlist[/{id}]", [PermissionMiddleware::class], "list.material_order")]
    public function list(Request $request, Response $response, array $args): Response
    {
        return $this->runPage($request, $response, $args, "MaterialOrderList");
    }

    // add
    #[Map(["GET","POST","OPTIONS"], "/materialorderadd[/{id}]", [PermissionMiddleware::class], "add.material_order")]
    public function add(Request $request, Response $response, array $args): Response
    {
        return $this->runPage($request, $response, $args, "MaterialOrderAdd");
    }

    // view
    #[Map(["GET","POST","OPTIONS"], "/materialorderview[/{id}]", [PermissionMiddleware::class], "view.material_order")]
    public function view(Request $request, Response $response, array $args): Response
    {
        return $this->runPage($request, $response, $args, "MaterialOrderView");
    }

    // edit
    #[Map(["GET","POST","OPTIONS"], "/materialorderedit[/{id}]", [PermissionMiddleware::class], "edit.material_order")]
    public function edit(Request $request, Response $response, array $args): Response
    {
        return $this->runPage($request, $response, $args, "MaterialOrderEdit");
    }

    // delete
    #[Map(["GET","POST","OPTIONS"], "/materialorderdelete[/{id}]", [PermissionMiddleware::class], "delete.material_order")]
    public function delete(Request $request, Response $response, array $args): Response
    {
        return $this->runPage($request, $response, $args, "MaterialOrderDelete");
    }
}
