<?php

namespace PHPMaker2024\fibre;

use Psr\Container\ContainerInterface;
use Psr\Http\Message\ServerRequestInterface as Request;
use Psr\Http\Message\ResponseInterface as Response;
use PHPMaker2024\fibre\Attributes\Delete;
use PHPMaker2024\fibre\Attributes\Get;
use PHPMaker2024\fibre\Attributes\Map;
use PHPMaker2024\fibre\Attributes\Options;
use PHPMaker2024\fibre\Attributes\Patch;
use PHPMaker2024\fibre\Attributes\Post;
use PHPMaker2024\fibre\Attributes\Put;

class MarginListMonthlyController extends ControllerBase
{
    // list
    #[Map(["GET","POST","OPTIONS"], "/marginlistmonthlylist", [PermissionMiddleware::class], "list.margin_list_monthly")]
    public function list(Request $request, Response $response, array $args): Response
    {
        return $this->runPage($request, $response, $args, "MarginListMonthlyList");
    }

    // add
    #[Map(["GET","POST","OPTIONS"], "/marginlistmonthlyadd", [PermissionMiddleware::class], "add.margin_list_monthly")]
    public function add(Request $request, Response $response, array $args): Response
    {
        return $this->runPage($request, $response, $args, "MarginListMonthlyAdd");
    }

    // search
    #[Map(["GET","POST","OPTIONS"], "/marginlistmonthlysearch", [PermissionMiddleware::class], "search.margin_list_monthly")]
    public function search(Request $request, Response $response, array $args): Response
    {
        return $this->runPage($request, $response, $args, "MarginListMonthlySearch");
    }
}
