<?php

namespace PHPMaker2024\fibre;

use Psr\Container\ContainerInterface;
use Psr\Http\Message\ServerRequestInterface as Request;
use Psr\Http\Message\ResponseInterface as Response;
use PHPMaker2024\fibre\Attributes\Delete;
use PHPMaker2024\fibre\Attributes\Get;
use PHPMaker2024\fibre\Attributes\Map;
use PHPMaker2024\fibre\Attributes\Options;
use PHPMaker2024\fibre\Attributes\Patch;
use PHPMaker2024\fibre\Attributes\Post;
use PHPMaker2024\fibre\Attributes\Put;

class MailSetupController extends ControllerBase
{
    // list
    #[Map(["GET","POST","OPTIONS"], "/mailsetuplist[/{id}]", [PermissionMiddleware::class], "list.mail_setup")]
    public function list(Request $request, Response $response, array $args): Response
    {
        return $this->runPage($request, $response, $args, "MailSetupList");
    }

    // add
    #[Map(["GET","POST","OPTIONS"], "/mailsetupadd[/{id}]", [PermissionMiddleware::class], "add.mail_setup")]
    public function add(Request $request, Response $response, array $args): Response
    {
        return $this->runPage($request, $response, $args, "MailSetupAdd");
    }

    // view
    #[Map(["GET","POST","OPTIONS"], "/mailsetupview[/{id}]", [PermissionMiddleware::class], "view.mail_setup")]
    public function view(Request $request, Response $response, array $args): Response
    {
        return $this->runPage($request, $response, $args, "MailSetupView");
    }

    // edit
    #[Map(["GET","POST","OPTIONS"], "/mailsetupedit[/{id}]", [PermissionMiddleware::class], "edit.mail_setup")]
    public function edit(Request $request, Response $response, array $args): Response
    {
        return $this->runPage($request, $response, $args, "MailSetupEdit");
    }

    // delete
    #[Map(["GET","POST","OPTIONS"], "/mailsetupdelete[/{id}]", [PermissionMiddleware::class], "delete.mail_setup")]
    public function delete(Request $request, Response $response, array $args): Response
    {
        return $this->runPage($request, $response, $args, "MailSetupDelete");
    }
}
