<?php

namespace PHPMaker2024\fibre;

use Psr\Container\ContainerInterface;
use Psr\Http\Message\ServerRequestInterface as Request;
use Psr\Http\Message\ResponseInterface as Response;
use PHPMaker2024\fibre\Attributes\Delete;
use PHPMaker2024\fibre\Attributes\Get;
use PHPMaker2024\fibre\Attributes\Map;
use PHPMaker2024\fibre\Attributes\Options;
use PHPMaker2024\fibre\Attributes\Patch;
use PHPMaker2024\fibre\Attributes\Post;
use PHPMaker2024\fibre\Attributes\Put;

class MailRecordController extends ControllerBase
{
    // list
    #[Map(["GET","POST","OPTIONS"], "/mailrecordlist[/{id}]", [PermissionMiddleware::class], "list.mail_record")]
    public function list(Request $request, Response $response, array $args): Response
    {
        return $this->runPage($request, $response, $args, "MailRecordList");
    }

    // view
    #[Map(["GET","POST","OPTIONS"], "/mailrecordview[/{id}]", [PermissionMiddleware::class], "view.mail_record")]
    public function view(Request $request, Response $response, array $args): Response
    {
        return $this->runPage($request, $response, $args, "MailRecordView");
    }

    // search
    #[Map(["GET","POST","OPTIONS"], "/mailrecordsearch", [PermissionMiddleware::class], "search.mail_record")]
    public function search(Request $request, Response $response, array $args): Response
    {
        return $this->runPage($request, $response, $args, "MailRecordSearch");
    }

    // query
    #[Map(["GET","POST","OPTIONS"], "/mailrecordquery", [PermissionMiddleware::class], "query.mail_record")]
    public function query(Request $request, Response $response, array $args): Response
    {
        return $this->runPage($request, $response, $args, "MailRecordSearch", "MailRecordQuery");
    }
}
