<?php

namespace PHPMaker2024\fibre;

use Psr\Container\ContainerInterface;
use Psr\Http\Message\ServerRequestInterface as Request;
use Psr\Http\Message\ResponseInterface as Response;
use PHPMaker2024\fibre\Attributes\Delete;
use PHPMaker2024\fibre\Attributes\Get;
use PHPMaker2024\fibre\Attributes\Map;
use PHPMaker2024\fibre\Attributes\Options;
use PHPMaker2024\fibre\Attributes\Patch;
use PHPMaker2024\fibre\Attributes\Post;
use PHPMaker2024\fibre\Attributes\Put;

class LotNoDetailsController extends ControllerBase
{
    // list
    #[Map(["GET","POST","OPTIONS"], "/lotnodetailslist[/{id}]", [PermissionMiddleware::class], "list.lot_no_details")]
    public function list(Request $request, Response $response, array $args): Response
    {
        return $this->runPage($request, $response, $args, "LotNoDetailsList");
    }

    // add
    #[Map(["GET","POST","OPTIONS"], "/lotnodetailsadd[/{id}]", [PermissionMiddleware::class], "add.lot_no_details")]
    public function add(Request $request, Response $response, array $args): Response
    {
        return $this->runPage($request, $response, $args, "LotNoDetailsAdd");
    }

    // view
    #[Map(["GET","POST","OPTIONS"], "/lotnodetailsview[/{id}]", [PermissionMiddleware::class], "view.lot_no_details")]
    public function view(Request $request, Response $response, array $args): Response
    {
        return $this->runPage($request, $response, $args, "LotNoDetailsView");
    }

    // edit
    #[Map(["GET","POST","OPTIONS"], "/lotnodetailsedit[/{id}]", [PermissionMiddleware::class], "edit.lot_no_details")]
    public function edit(Request $request, Response $response, array $args): Response
    {
        return $this->runPage($request, $response, $args, "LotNoDetailsEdit");
    }

    // delete
    #[Map(["GET","POST","OPTIONS"], "/lotnodetailsdelete[/{id}]", [PermissionMiddleware::class], "delete.lot_no_details")]
    public function delete(Request $request, Response $response, array $args): Response
    {
        return $this->runPage($request, $response, $args, "LotNoDetailsDelete");
    }
}
