<?php

namespace PHPMaker2024\fibre;

use Psr\Container\ContainerInterface;
use Psr\Http\Message\ServerRequestInterface as Request;
use Psr\Http\Message\ResponseInterface as Response;
use PHPMaker2024\fibre\Attributes\Delete;
use PHPMaker2024\fibre\Attributes\Get;
use PHPMaker2024\fibre\Attributes\Map;
use PHPMaker2024\fibre\Attributes\Options;
use PHPMaker2024\fibre\Attributes\Patch;
use PHPMaker2024\fibre\Attributes\Post;
use PHPMaker2024\fibre\Attributes\Put;

class LoomInfoController extends ControllerBase
{
    // list
    #[Map(["GET","POST","OPTIONS"], "/loominfolist[/{id}]", [PermissionMiddleware::class], "list.loom_info")]
    public function list(Request $request, Response $response, array $args): Response
    {
        return $this->runPage($request, $response, $args, "LoomInfoList");
    }

    // add
    #[Map(["GET","POST","OPTIONS"], "/loominfoadd[/{id}]", [PermissionMiddleware::class], "add.loom_info")]
    public function add(Request $request, Response $response, array $args): Response
    {
        return $this->runPage($request, $response, $args, "LoomInfoAdd");
    }

    // view
    #[Map(["GET","POST","OPTIONS"], "/loominfoview[/{id}]", [PermissionMiddleware::class], "view.loom_info")]
    public function view(Request $request, Response $response, array $args): Response
    {
        return $this->runPage($request, $response, $args, "LoomInfoView");
    }

    // edit
    #[Map(["GET","POST","OPTIONS"], "/loominfoedit[/{id}]", [PermissionMiddleware::class], "edit.loom_info")]
    public function edit(Request $request, Response $response, array $args): Response
    {
        return $this->runPage($request, $response, $args, "LoomInfoEdit");
    }

    // search
    #[Map(["GET","POST","OPTIONS"], "/loominfosearch", [PermissionMiddleware::class], "search.loom_info")]
    public function search(Request $request, Response $response, array $args): Response
    {
        return $this->runPage($request, $response, $args, "LoomInfoSearch");
    }
}
