<?php

namespace PHPMaker2024\fibre;

use Psr\Container\ContainerInterface;
use Psr\Http\Message\ServerRequestInterface as Request;
use Psr\Http\Message\ResponseInterface as Response;
use PHPMaker2024\fibre\Attributes\Delete;
use PHPMaker2024\fibre\Attributes\Get;
use PHPMaker2024\fibre\Attributes\Map;
use PHPMaker2024\fibre\Attributes\Options;
use PHPMaker2024\fibre\Attributes\Patch;
use PHPMaker2024\fibre\Attributes\Post;
use PHPMaker2024\fibre\Attributes\Put;

class LoginipController extends ControllerBase
{
    // list
    #[Map(["GET","POST","OPTIONS"], "/loginiplist[/{id}]", [PermissionMiddleware::class], "list.loginip")]
    public function list(Request $request, Response $response, array $args): Response
    {
        return $this->runPage($request, $response, $args, "LoginipList");
    }

    // add
    #[Map(["GET","POST","OPTIONS"], "/loginipadd[/{id}]", [PermissionMiddleware::class], "add.loginip")]
    public function add(Request $request, Response $response, array $args): Response
    {
        return $this->runPage($request, $response, $args, "LoginipAdd");
    }

    // view
    #[Map(["GET","POST","OPTIONS"], "/loginipview[/{id}]", [PermissionMiddleware::class], "view.loginip")]
    public function view(Request $request, Response $response, array $args): Response
    {
        return $this->runPage($request, $response, $args, "LoginipView");
    }

    // edit
    #[Map(["GET","POST","OPTIONS"], "/loginipedit[/{id}]", [PermissionMiddleware::class], "edit.loginip")]
    public function edit(Request $request, Response $response, array $args): Response
    {
        return $this->runPage($request, $response, $args, "LoginipEdit");
    }

    // delete
    #[Map(["GET","POST","OPTIONS"], "/loginipdelete[/{id}]", [PermissionMiddleware::class], "delete.loginip")]
    public function delete(Request $request, Response $response, array $args): Response
    {
        return $this->runPage($request, $response, $args, "LoginipDelete");
    }
}
