<?php

namespace PHPMaker2024\fibre;

use Psr\Container\ContainerInterface;
use Psr\Http\Message\ServerRequestInterface as Request;
use Psr\Http\Message\ResponseInterface as Response;
use PHPMaker2024\fibre\Attributes\Delete;
use PHPMaker2024\fibre\Attributes\Get;
use PHPMaker2024\fibre\Attributes\Map;
use PHPMaker2024\fibre\Attributes\Options;
use PHPMaker2024\fibre\Attributes\Patch;
use PHPMaker2024\fibre\Attributes\Post;
use PHPMaker2024\fibre\Attributes\Put;

class LocationsController extends ControllerBase
{
    // list
    #[Map(["GET","POST","OPTIONS"], "/locationslist[/{id}]", [PermissionMiddleware::class], "list.locations")]
    public function list(Request $request, Response $response, array $args): Response
    {
        return $this->runPage($request, $response, $args, "LocationsList");
    }

    // add
    #[Map(["GET","POST","OPTIONS"], "/locationsadd[/{id}]", [PermissionMiddleware::class], "add.locations")]
    public function add(Request $request, Response $response, array $args): Response
    {
        return $this->runPage($request, $response, $args, "LocationsAdd");
    }

    // view
    #[Map(["GET","POST","OPTIONS"], "/locationsview[/{id}]", [PermissionMiddleware::class], "view.locations")]
    public function view(Request $request, Response $response, array $args): Response
    {
        return $this->runPage($request, $response, $args, "LocationsView");
    }

    // edit
    #[Map(["GET","POST","OPTIONS"], "/locationsedit[/{id}]", [PermissionMiddleware::class], "edit.locations")]
    public function edit(Request $request, Response $response, array $args): Response
    {
        return $this->runPage($request, $response, $args, "LocationsEdit");
    }

    // delete
    #[Map(["GET","POST","OPTIONS"], "/locationsdelete[/{id}]", [PermissionMiddleware::class], "delete.locations")]
    public function delete(Request $request, Response $response, array $args): Response
    {
        return $this->runPage($request, $response, $args, "LocationsDelete");
    }

    // search
    #[Map(["GET","POST","OPTIONS"], "/locationssearch", [PermissionMiddleware::class], "search.locations")]
    public function search(Request $request, Response $response, array $args): Response
    {
        return $this->runPage($request, $response, $args, "LocationsSearch");
    }

    // query
    #[Map(["GET","POST","OPTIONS"], "/locationsquery", [PermissionMiddleware::class], "query.locations")]
    public function query(Request $request, Response $response, array $args): Response
    {
        return $this->runPage($request, $response, $args, "LocationsSearch", "LocationsQuery");
    }
}
