<?php

namespace PHPMaker2024\fibre;

use Psr\Container\ContainerInterface;
use Psr\Http\Message\ServerRequestInterface as Request;
use Psr\Http\Message\ResponseInterface as Response;
use PHPMaker2024\fibre\Attributes\Delete;
use PHPMaker2024\fibre\Attributes\Get;
use PHPMaker2024\fibre\Attributes\Map;
use PHPMaker2024\fibre\Attributes\Options;
use PHPMaker2024\fibre\Attributes\Patch;
use PHPMaker2024\fibre\Attributes\Post;
use PHPMaker2024\fibre\Attributes\Put;

class LedgerController extends ControllerBase
{
    // list
    #[Map(["GET","POST","OPTIONS"], "/ledgerlist[/{uid}]", [PermissionMiddleware::class], "list.ledger")]
    public function list(Request $request, Response $response, array $args): Response
    {
        return $this->runPage($request, $response, $args, "LedgerList");
    }

    // view
    #[Map(["GET","POST","OPTIONS"], "/ledgerview[/{uid}]", [PermissionMiddleware::class], "view.ledger")]
    public function view(Request $request, Response $response, array $args): Response
    {
        return $this->runPage($request, $response, $args, "LedgerView");
    }

    // search
    #[Map(["GET","POST","OPTIONS"], "/ledgersearch", [PermissionMiddleware::class], "search.ledger")]
    public function search(Request $request, Response $response, array $args): Response
    {
        return $this->runPage($request, $response, $args, "LedgerSearch");
    }
}
