<?php

namespace PHPMaker2024\fibre;

use Psr\Container\ContainerInterface;
use Psr\Http\Message\ServerRequestInterface as Request;
use Psr\Http\Message\ResponseInterface as Response;
use PHPMaker2024\fibre\Attributes\Delete;
use PHPMaker2024\fibre\Attributes\Get;
use PHPMaker2024\fibre\Attributes\Map;
use PHPMaker2024\fibre\Attributes\Options;
use PHPMaker2024\fibre\Attributes\Patch;
use PHPMaker2024\fibre\Attributes\Post;
use PHPMaker2024\fibre\Attributes\Put;

class LReferralController extends ControllerBase
{
    // list
    #[Map(["GET","POST","OPTIONS"], "/lreferrallist[/{id}]", [PermissionMiddleware::class], "list.l_referral")]
    public function list(Request $request, Response $response, array $args): Response
    {
        return $this->runPage($request, $response, $args, "LReferralList");
    }

    // add
    #[Map(["GET","POST","OPTIONS"], "/lreferraladd[/{id}]", [PermissionMiddleware::class], "add.l_referral")]
    public function add(Request $request, Response $response, array $args): Response
    {
        return $this->runPage($request, $response, $args, "LReferralAdd");
    }

    // edit
    #[Map(["GET","POST","OPTIONS"], "/lreferraledit[/{id}]", [PermissionMiddleware::class], "edit.l_referral")]
    public function edit(Request $request, Response $response, array $args): Response
    {
        return $this->runPage($request, $response, $args, "LReferralEdit");
    }
}
