<?php

namespace PHPMaker2024\fibre;

use Psr\Container\ContainerInterface;
use Psr\Http\Message\ServerRequestInterface as Request;
use Psr\Http\Message\ResponseInterface as Response;
use PHPMaker2024\fibre\Attributes\Delete;
use PHPMaker2024\fibre\Attributes\Get;
use PHPMaker2024\fibre\Attributes\Map;
use PHPMaker2024\fibre\Attributes\Options;
use PHPMaker2024\fibre\Attributes\Patch;
use PHPMaker2024\fibre\Attributes\Post;
use PHPMaker2024\fibre\Attributes\Put;

class LReceiptController extends ControllerBase
{
    // list
    #[Map(["GET","POST","OPTIONS"], "/lreceiptlist[/{id}]", [PermissionMiddleware::class], "list.l_receipt")]
    public function list(Request $request, Response $response, array $args): Response
    {
        return $this->runPage($request, $response, $args, "LReceiptList");
    }

    // add
    #[Map(["GET","POST","OPTIONS"], "/lreceiptadd[/{id}]", [PermissionMiddleware::class], "add.l_receipt")]
    public function add(Request $request, Response $response, array $args): Response
    {
        return $this->runPage($request, $response, $args, "LReceiptAdd");
    }

    // view
    #[Map(["GET","POST","OPTIONS"], "/lreceiptview[/{id}]", [PermissionMiddleware::class], "view.l_receipt")]
    public function view(Request $request, Response $response, array $args): Response
    {
        return $this->runPage($request, $response, $args, "LReceiptView");
    }

    // edit
    #[Map(["GET","POST","OPTIONS"], "/lreceiptedit[/{id}]", [PermissionMiddleware::class], "edit.l_receipt")]
    public function edit(Request $request, Response $response, array $args): Response
    {
        return $this->runPage($request, $response, $args, "LReceiptEdit");
    }

    // delete
    #[Map(["GET","POST","OPTIONS"], "/lreceiptdelete[/{id}]", [PermissionMiddleware::class], "delete.l_receipt")]
    public function delete(Request $request, Response $response, array $args): Response
    {
        return $this->runPage($request, $response, $args, "LReceiptDelete");
    }

    // search
    #[Map(["GET","POST","OPTIONS"], "/lreceiptsearch", [PermissionMiddleware::class], "search.l_receipt")]
    public function search(Request $request, Response $response, array $args): Response
    {
        return $this->runPage($request, $response, $args, "LReceiptSearch");
    }
}
