<?php

namespace PHPMaker2024\fibre;

use Psr\Container\ContainerInterface;
use Psr\Http\Message\ServerRequestInterface as Request;
use Psr\Http\Message\ResponseInterface as Response;
use PHPMaker2024\fibre\Attributes\Delete;
use PHPMaker2024\fibre\Attributes\Get;
use PHPMaker2024\fibre\Attributes\Map;
use PHPMaker2024\fibre\Attributes\Options;
use PHPMaker2024\fibre\Attributes\Patch;
use PHPMaker2024\fibre\Attributes\Post;
use PHPMaker2024\fibre\Attributes\Put;

class LExaminationTypeController extends ControllerBase
{
    // list
    #[Map(["GET","POST","OPTIONS"], "/lexaminationtypelist[/{id}]", [PermissionMiddleware::class], "list.l_examination_type")]
    public function list(Request $request, Response $response, array $args): Response
    {
        return $this->runPage($request, $response, $args, "LExaminationTypeList");
    }

    // add
    #[Map(["GET","POST","OPTIONS"], "/lexaminationtypeadd[/{id}]", [PermissionMiddleware::class], "add.l_examination_type")]
    public function add(Request $request, Response $response, array $args): Response
    {
        return $this->runPage($request, $response, $args, "LExaminationTypeAdd");
    }

    // view
    #[Map(["GET","POST","OPTIONS"], "/lexaminationtypeview[/{id}]", [PermissionMiddleware::class], "view.l_examination_type")]
    public function view(Request $request, Response $response, array $args): Response
    {
        return $this->runPage($request, $response, $args, "LExaminationTypeView");
    }

    // edit
    #[Map(["GET","POST","OPTIONS"], "/lexaminationtypeedit[/{id}]", [PermissionMiddleware::class], "edit.l_examination_type")]
    public function edit(Request $request, Response $response, array $args): Response
    {
        return $this->runPage($request, $response, $args, "LExaminationTypeEdit");
    }

    // search
    #[Map(["GET","POST","OPTIONS"], "/lexaminationtypesearch", [PermissionMiddleware::class], "search.l_examination_type")]
    public function search(Request $request, Response $response, array $args): Response
    {
        return $this->runPage($request, $response, $args, "LExaminationTypeSearch");
    }
}
