<?php

namespace PHPMaker2024\fibre;

use Psr\Container\ContainerInterface;
use Psr\Http\Message\ServerRequestInterface as Request;
use Psr\Http\Message\ResponseInterface as Response;
use PHPMaker2024\fibre\Attributes\Delete;
use PHPMaker2024\fibre\Attributes\Get;
use PHPMaker2024\fibre\Attributes\Map;
use PHPMaker2024\fibre\Attributes\Options;
use PHPMaker2024\fibre\Attributes\Patch;
use PHPMaker2024\fibre\Attributes\Post;
use PHPMaker2024\fibre\Attributes\Put;

class LExaminationReportController extends ControllerBase
{
    // list
    #[Map(["GET","POST","OPTIONS"], "/lexaminationreportlist[/{uid:.*}]", [PermissionMiddleware::class], "list.l_examination_report")]
    public function list(Request $request, Response $response, array $args): Response
    {
        return $this->runPage($request, $response, $args, "LExaminationReportList");
    }

    // view
    #[Map(["GET","POST","OPTIONS"], "/lexaminationreportview[/{uid:.*}]", [PermissionMiddleware::class], "view.l_examination_report")]
    public function view(Request $request, Response $response, array $args): Response
    {
        return $this->runPage($request, $response, $args, "LExaminationReportView");
    }

    // edit
    #[Map(["GET","POST","OPTIONS"], "/lexaminationreportedit[/{uid:.*}]", [PermissionMiddleware::class], "edit.l_examination_report")]
    public function edit(Request $request, Response $response, array $args): Response
    {
        return $this->runPage($request, $response, $args, "LExaminationReportEdit");
    }

    // search
    #[Map(["GET","POST","OPTIONS"], "/lexaminationreportsearch", [PermissionMiddleware::class], "search.l_examination_report")]
    public function search(Request $request, Response $response, array $args): Response
    {
        return $this->runPage($request, $response, $args, "LExaminationReportSearch");
    }
}
