<?php

namespace PHPMaker2024\fibre;

use Psr\Container\ContainerInterface;
use Psr\Http\Message\ServerRequestInterface as Request;
use Psr\Http\Message\ResponseInterface as Response;
use PHPMaker2024\fibre\Attributes\Delete;
use PHPMaker2024\fibre\Attributes\Get;
use PHPMaker2024\fibre\Attributes\Map;
use PHPMaker2024\fibre\Attributes\Options;
use PHPMaker2024\fibre\Attributes\Patch;
use PHPMaker2024\fibre\Attributes\Post;
use PHPMaker2024\fibre\Attributes\Put;

class LExaminationController extends ControllerBase
{
    // list
    #[Map(["GET","POST","OPTIONS"], "/lexaminationlist[/{id}]", [PermissionMiddleware::class], "list.l_examination")]
    public function list(Request $request, Response $response, array $args): Response
    {
        return $this->runPage($request, $response, $args, "LExaminationList");
    }

    // add
    #[Map(["GET","POST","OPTIONS"], "/lexaminationadd[/{id}]", [PermissionMiddleware::class], "add.l_examination")]
    public function add(Request $request, Response $response, array $args): Response
    {
        return $this->runPage($request, $response, $args, "LExaminationAdd");
    }

    // view
    #[Map(["GET","POST","OPTIONS"], "/lexaminationview[/{id}]", [PermissionMiddleware::class], "view.l_examination")]
    public function view(Request $request, Response $response, array $args): Response
    {
        return $this->runPage($request, $response, $args, "LExaminationView");
    }

    // edit
    #[Map(["GET","POST","OPTIONS"], "/lexaminationedit[/{id}]", [PermissionMiddleware::class], "edit.l_examination")]
    public function edit(Request $request, Response $response, array $args): Response
    {
        return $this->runPage($request, $response, $args, "LExaminationEdit");
    }

    // search
    #[Map(["GET","POST","OPTIONS"], "/lexaminationsearch", [PermissionMiddleware::class], "search.l_examination")]
    public function search(Request $request, Response $response, array $args): Response
    {
        return $this->runPage($request, $response, $args, "LExaminationSearch");
    }
}
