<?php

namespace PHPMaker2024\fibre;

use Psr\Container\ContainerInterface;
use Psr\Http\Message\ServerRequestInterface as Request;
use Psr\Http\Message\ResponseInterface as Response;
use PHPMaker2024\fibre\Attributes\Delete;
use PHPMaker2024\fibre\Attributes\Get;
use PHPMaker2024\fibre\Attributes\Map;
use PHPMaker2024\fibre\Attributes\Options;
use PHPMaker2024\fibre\Attributes\Patch;
use PHPMaker2024\fibre\Attributes\Post;
use PHPMaker2024\fibre\Attributes\Put;

class JournalController extends ControllerBase
{
    // list
    #[Map(["GET","POST","OPTIONS"], "/journallist[/{id}]", [PermissionMiddleware::class], "list.journal")]
    public function list(Request $request, Response $response, array $args): Response
    {
        return $this->runPage($request, $response, $args, "JournalList");
    }

    // add
    #[Map(["GET","POST","OPTIONS"], "/journaladd[/{id}]", [PermissionMiddleware::class], "add.journal")]
    public function add(Request $request, Response $response, array $args): Response
    {
        return $this->runPage($request, $response, $args, "JournalAdd");
    }

    // view
    #[Map(["GET","POST","OPTIONS"], "/journalview[/{id}]", [PermissionMiddleware::class], "view.journal")]
    public function view(Request $request, Response $response, array $args): Response
    {
        return $this->runPage($request, $response, $args, "JournalView");
    }

    // edit
    #[Map(["GET","POST","OPTIONS"], "/journaledit[/{id}]", [PermissionMiddleware::class], "edit.journal")]
    public function edit(Request $request, Response $response, array $args): Response
    {
        return $this->runPage($request, $response, $args, "JournalEdit");
    }

    // delete
    #[Map(["GET","POST","OPTIONS"], "/journaldelete[/{id}]", [PermissionMiddleware::class], "delete.journal")]
    public function delete(Request $request, Response $response, array $args): Response
    {
        return $this->runPage($request, $response, $args, "JournalDelete");
    }

    // search
    #[Map(["GET","POST","OPTIONS"], "/journalsearch", [PermissionMiddleware::class], "search.journal")]
    public function search(Request $request, Response $response, array $args): Response
    {
        return $this->runPage($request, $response, $args, "JournalSearch");
    }
}
