<?php

namespace PHPMaker2024\fibre;

use Psr\Container\ContainerInterface;
use Psr\Http\Message\ServerRequestInterface as Request;
use Psr\Http\Message\ResponseInterface as Response;
use PHPMaker2024\fibre\Attributes\Delete;
use PHPMaker2024\fibre\Attributes\Get;
use PHPMaker2024\fibre\Attributes\Map;
use PHPMaker2024\fibre\Attributes\Options;
use PHPMaker2024\fibre\Attributes\Patch;
use PHPMaker2024\fibre\Attributes\Post;
use PHPMaker2024\fibre\Attributes\Put;

class JobCardPendingQueryController extends ControllerBase
{
    // list
    #[Map(["GET","POST","OPTIONS"], "/jobcardpendingquerylist[/{id}]", [PermissionMiddleware::class], "list.job_card_pending_query")]
    public function list(Request $request, Response $response, array $args): Response
    {
        return $this->runPage($request, $response, $args, "JobCardPendingQueryList");
    }

    // view
    #[Map(["GET","POST","OPTIONS"], "/jobcardpendingqueryview[/{id}]", [PermissionMiddleware::class], "view.job_card_pending_query")]
    public function view(Request $request, Response $response, array $args): Response
    {
        return $this->runPage($request, $response, $args, "JobCardPendingQueryView");
    }

    // search
    #[Map(["GET","POST","OPTIONS"], "/jobcardpendingquerysearch", [PermissionMiddleware::class], "search.job_card_pending_query")]
    public function search(Request $request, Response $response, array $args): Response
    {
        return $this->runPage($request, $response, $args, "JobCardPendingQuerySearch");
    }

    // query
    #[Map(["GET","POST","OPTIONS"], "/jobcardpendingqueryquery", [PermissionMiddleware::class], "query.job_card_pending_query")]
    public function query(Request $request, Response $response, array $args): Response
    {
        return $this->runPage($request, $response, $args, "JobCardPendingQuerySearch", "JobCardPendingQueryQuery");
    }
}
