<?php

namespace PHPMaker2024\fibre;

use Psr\Container\ContainerInterface;
use Psr\Http\Message\ServerRequestInterface as Request;
use Psr\Http\Message\ResponseInterface as Response;
use PHPMaker2024\fibre\Attributes\Delete;
use PHPMaker2024\fibre\Attributes\Get;
use PHPMaker2024\fibre\Attributes\Map;
use PHPMaker2024\fibre\Attributes\Options;
use PHPMaker2024\fibre\Attributes\Patch;
use PHPMaker2024\fibre\Attributes\Post;
use PHPMaker2024\fibre\Attributes\Put;

class JobCardHsController extends ControllerBase
{
    // list
    #[Map(["GET","POST","OPTIONS"], "/jobcardhslist[/{id}]", [PermissionMiddleware::class], "list.job_card_hs")]
    public function list(Request $request, Response $response, array $args): Response
    {
        return $this->runPage($request, $response, $args, "JobCardHsList");
    }

    // add
    #[Map(["GET","POST","OPTIONS"], "/jobcardhsadd[/{id}]", [PermissionMiddleware::class], "add.job_card_hs")]
    public function add(Request $request, Response $response, array $args): Response
    {
        return $this->runPage($request, $response, $args, "JobCardHsAdd");
    }

    // view
    #[Map(["GET","POST","OPTIONS"], "/jobcardhsview[/{id}]", [PermissionMiddleware::class], "view.job_card_hs")]
    public function view(Request $request, Response $response, array $args): Response
    {
        return $this->runPage($request, $response, $args, "JobCardHsView");
    }

    // edit
    #[Map(["GET","POST","OPTIONS"], "/jobcardhsedit[/{id}]", [PermissionMiddleware::class], "edit.job_card_hs")]
    public function edit(Request $request, Response $response, array $args): Response
    {
        return $this->runPage($request, $response, $args, "JobCardHsEdit");
    }

    // delete
    #[Map(["GET","POST","OPTIONS"], "/jobcardhsdelete[/{id}]", [PermissionMiddleware::class], "delete.job_card_hs")]
    public function delete(Request $request, Response $response, array $args): Response
    {
        return $this->runPage($request, $response, $args, "JobCardHsDelete");
    }

    // search
    #[Map(["GET","POST","OPTIONS"], "/jobcardhssearch", [PermissionMiddleware::class], "search.job_card_hs")]
    public function search(Request $request, Response $response, array $args): Response
    {
        return $this->runPage($request, $response, $args, "JobCardHsSearch");
    }
}
