<?php

namespace PHPMaker2024\fibre;

use Psr\Container\ContainerInterface;
use Psr\Http\Message\ServerRequestInterface as Request;
use Psr\Http\Message\ResponseInterface as Response;
use PHPMaker2024\fibre\Attributes\Delete;
use PHPMaker2024\fibre\Attributes\Get;
use PHPMaker2024\fibre\Attributes\Map;
use PHPMaker2024\fibre\Attributes\Options;
use PHPMaker2024\fibre\Attributes\Patch;
use PHPMaker2024\fibre\Attributes\Post;
use PHPMaker2024\fibre\Attributes\Put;

class JobCardDescriptionController extends ControllerBase
{
    // list
    #[Map(["GET","POST","OPTIONS"], "/jobcarddescriptionlist[/{id}]", [PermissionMiddleware::class], "list.job_card_description")]
    public function list(Request $request, Response $response, array $args): Response
    {
        return $this->runPage($request, $response, $args, "JobCardDescriptionList");
    }

    // add
    #[Map(["GET","POST","OPTIONS"], "/jobcarddescriptionadd[/{id}]", [PermissionMiddleware::class], "add.job_card_description")]
    public function add(Request $request, Response $response, array $args): Response
    {
        return $this->runPage($request, $response, $args, "JobCardDescriptionAdd");
    }

    // view
    #[Map(["GET","POST","OPTIONS"], "/jobcarddescriptionview[/{id}]", [PermissionMiddleware::class], "view.job_card_description")]
    public function view(Request $request, Response $response, array $args): Response
    {
        return $this->runPage($request, $response, $args, "JobCardDescriptionView");
    }

    // edit
    #[Map(["GET","POST","OPTIONS"], "/jobcarddescriptionedit[/{id}]", [PermissionMiddleware::class], "edit.job_card_description")]
    public function edit(Request $request, Response $response, array $args): Response
    {
        return $this->runPage($request, $response, $args, "JobCardDescriptionEdit");
    }

    // delete
    #[Map(["GET","POST","OPTIONS"], "/jobcarddescriptiondelete[/{id}]", [PermissionMiddleware::class], "delete.job_card_description")]
    public function delete(Request $request, Response $response, array $args): Response
    {
        return $this->runPage($request, $response, $args, "JobCardDescriptionDelete");
    }

    // search
    #[Map(["GET","POST","OPTIONS"], "/jobcarddescriptionsearch", [PermissionMiddleware::class], "search.job_card_description")]
    public function search(Request $request, Response $response, array $args): Response
    {
        return $this->runPage($request, $response, $args, "JobCardDescriptionSearch");
    }
}
