<?php

namespace PHPMaker2024\fibre;

use Psr\Container\ContainerInterface;
use Psr\Http\Message\ServerRequestInterface as Request;
use Psr\Http\Message\ResponseInterface as Response;
use PHPMaker2024\fibre\Attributes\Delete;
use PHPMaker2024\fibre\Attributes\Get;
use PHPMaker2024\fibre\Attributes\Map;
use PHPMaker2024\fibre\Attributes\Options;
use PHPMaker2024\fibre\Attributes\Patch;
use PHPMaker2024\fibre\Attributes\Post;
use PHPMaker2024\fibre\Attributes\Put;

class JobCardController extends ControllerBase
{
    // list
    #[Map(["GET","POST","OPTIONS"], "/jobcardlist[/{id}]", [PermissionMiddleware::class], "list.job_card")]
    public function list(Request $request, Response $response, array $args): Response
    {
        return $this->runPage($request, $response, $args, "JobCardList");
    }

    // add
    #[Map(["GET","POST","OPTIONS"], "/jobcardadd[/{id}]", [PermissionMiddleware::class], "add.job_card")]
    public function add(Request $request, Response $response, array $args): Response
    {
        return $this->runPage($request, $response, $args, "JobCardAdd");
    }

    // view
    #[Map(["GET","POST","OPTIONS"], "/jobcardview[/{id}]", [PermissionMiddleware::class], "view.job_card")]
    public function view(Request $request, Response $response, array $args): Response
    {
        return $this->runPage($request, $response, $args, "JobCardView");
    }

    // edit
    #[Map(["GET","POST","OPTIONS"], "/jobcardedit[/{id}]", [PermissionMiddleware::class], "edit.job_card")]
    public function edit(Request $request, Response $response, array $args): Response
    {
        return $this->runPage($request, $response, $args, "JobCardEdit");
    }

    // search
    #[Map(["GET","POST","OPTIONS"], "/jobcardsearch", [PermissionMiddleware::class], "search.job_card")]
    public function search(Request $request, Response $response, array $args): Response
    {
        return $this->runPage($request, $response, $args, "JobCardSearch");
    }
}
