<?php

namespace PHPMaker2024\fibre;

use Psr\Container\ContainerInterface;
use Psr\Http\Message\ServerRequestInterface as Request;
use Psr\Http\Message\ResponseInterface as Response;
use PHPMaker2024\fibre\Attributes\Delete;
use PHPMaker2024\fibre\Attributes\Get;
use PHPMaker2024\fibre\Attributes\Map;
use PHPMaker2024\fibre\Attributes\Options;
use PHPMaker2024\fibre\Attributes\Patch;
use PHPMaker2024\fibre\Attributes\Post;
use PHPMaker2024\fibre\Attributes\Put;

class JobCardBcOldController extends ControllerBase
{
    // list
    #[Map(["GET","POST","OPTIONS"], "/jobcardbcoldlist[/{id}]", [PermissionMiddleware::class], "list.job_card_bc_old")]
    public function list(Request $request, Response $response, array $args): Response
    {
        return $this->runPage($request, $response, $args, "JobCardBcOldList");
    }

    // view
    #[Map(["GET","POST","OPTIONS"], "/jobcardbcoldview[/{id}]", [PermissionMiddleware::class], "view.job_card_bc_old")]
    public function view(Request $request, Response $response, array $args): Response
    {
        return $this->runPage($request, $response, $args, "JobCardBcOldView");
    }

    // search
    #[Map(["GET","POST","OPTIONS"], "/jobcardbcoldsearch", [PermissionMiddleware::class], "search.job_card_bc_old")]
    public function search(Request $request, Response $response, array $args): Response
    {
        return $this->runPage($request, $response, $args, "JobCardBcOldSearch");
    }

    // query
    #[Map(["GET","POST","OPTIONS"], "/jobcardbcoldquery", [PermissionMiddleware::class], "query.job_card_bc_old")]
    public function query(Request $request, Response $response, array $args): Response
    {
        return $this->runPage($request, $response, $args, "JobCardBcOldSearch", "JobCardBcOldQuery");
    }
}
