<?php

namespace PHPMaker2024\fibre;

use Psr\Container\ContainerInterface;
use Psr\Http\Message\ServerRequestInterface as Request;
use Psr\Http\Message\ResponseInterface as Response;
use PHPMaker2024\fibre\Attributes\Delete;
use PHPMaker2024\fibre\Attributes\Get;
use PHPMaker2024\fibre\Attributes\Map;
use PHPMaker2024\fibre\Attributes\Options;
use PHPMaker2024\fibre\Attributes\Patch;
use PHPMaker2024\fibre\Attributes\Post;
use PHPMaker2024\fibre\Attributes\Put;

class JobCardBcController extends ControllerBase
{
    // list
    #[Map(["GET","POST","OPTIONS"], "/jobcardbclist[/{id}]", [PermissionMiddleware::class], "list.job_card_bc")]
    public function list(Request $request, Response $response, array $args): Response
    {
        return $this->runPage($request, $response, $args, "JobCardBcList");
    }

    // add
    #[Map(["GET","POST","OPTIONS"], "/jobcardbcadd[/{id}]", [PermissionMiddleware::class], "add.job_card_bc")]
    public function add(Request $request, Response $response, array $args): Response
    {
        return $this->runPage($request, $response, $args, "JobCardBcAdd");
    }

    // view
    #[Map(["GET","POST","OPTIONS"], "/jobcardbcview[/{id}]", [PermissionMiddleware::class], "view.job_card_bc")]
    public function view(Request $request, Response $response, array $args): Response
    {
        return $this->runPage($request, $response, $args, "JobCardBcView");
    }

    // search
    #[Map(["GET","POST","OPTIONS"], "/jobcardbcsearch", [PermissionMiddleware::class], "search.job_card_bc")]
    public function search(Request $request, Response $response, array $args): Response
    {
        return $this->runPage($request, $response, $args, "JobCardBcSearch");
    }

    // query
    #[Map(["GET","POST","OPTIONS"], "/jobcardbcquery", [PermissionMiddleware::class], "query.job_card_bc")]
    public function query(Request $request, Response $response, array $args): Response
    {
        return $this->runPage($request, $response, $args, "JobCardBcSearch", "JobCardBcQuery");
    }
}
