<?php

namespace PHPMaker2024\fibre;

use Psr\Container\ContainerInterface;
use Psr\Http\Message\ServerRequestInterface as Request;
use Psr\Http\Message\ResponseInterface as Response;
use PHPMaker2024\fibre\Attributes\Delete;
use PHPMaker2024\fibre\Attributes\Get;
use PHPMaker2024\fibre\Attributes\Map;
use PHPMaker2024\fibre\Attributes\Options;
use PHPMaker2024\fibre\Attributes\Patch;
use PHPMaker2024\fibre\Attributes\Post;
use PHPMaker2024\fibre\Attributes\Put;

class InvestorListController extends ControllerBase
{
    // list
    #[Map(["GET","POST","OPTIONS"], "/investorlistlist[/{id}]", [PermissionMiddleware::class], "list.investor_list")]
    public function list(Request $request, Response $response, array $args): Response
    {
        return $this->runPage($request, $response, $args, "InvestorListList");
    }

    // add
    #[Map(["GET","POST","OPTIONS"], "/investorlistadd[/{id}]", [PermissionMiddleware::class], "add.investor_list")]
    public function add(Request $request, Response $response, array $args): Response
    {
        return $this->runPage($request, $response, $args, "InvestorListAdd");
    }

    // view
    #[Map(["GET","POST","OPTIONS"], "/investorlistview[/{id}]", [PermissionMiddleware::class], "view.investor_list")]
    public function view(Request $request, Response $response, array $args): Response
    {
        return $this->runPage($request, $response, $args, "InvestorListView");
    }

    // search
    #[Map(["GET","POST","OPTIONS"], "/investorlistsearch", [PermissionMiddleware::class], "search.investor_list")]
    public function search(Request $request, Response $response, array $args): Response
    {
        return $this->runPage($request, $response, $args, "InvestorListSearch");
    }
}
