<?php

namespace PHPMaker2024\fibre;

use Psr\Container\ContainerInterface;
use Psr\Http\Message\ServerRequestInterface as Request;
use Psr\Http\Message\ResponseInterface as Response;
use PHPMaker2024\fibre\Attributes\Delete;
use PHPMaker2024\fibre\Attributes\Get;
use PHPMaker2024\fibre\Attributes\Map;
use PHPMaker2024\fibre\Attributes\Options;
use PHPMaker2024\fibre\Attributes\Patch;
use PHPMaker2024\fibre\Attributes\Post;
use PHPMaker2024\fibre\Attributes\Put;

class InvestorInfoController extends ControllerBase
{
    // list
    #[Map(["GET","POST","OPTIONS"], "/investorinfolist[/{id}]", [PermissionMiddleware::class], "list.investor_info")]
    public function list(Request $request, Response $response, array $args): Response
    {
        return $this->runPage($request, $response, $args, "InvestorInfoList");
    }

    // add
    #[Map(["GET","POST","OPTIONS"], "/investorinfoadd[/{id}]", [PermissionMiddleware::class], "add.investor_info")]
    public function add(Request $request, Response $response, array $args): Response
    {
        return $this->runPage($request, $response, $args, "InvestorInfoAdd");
    }

    // view
    #[Map(["GET","POST","OPTIONS"], "/investorinfoview[/{id}]", [PermissionMiddleware::class], "view.investor_info")]
    public function view(Request $request, Response $response, array $args): Response
    {
        return $this->runPage($request, $response, $args, "InvestorInfoView");
    }

    // edit
    #[Map(["GET","POST","OPTIONS"], "/investorinfoedit[/{id}]", [PermissionMiddleware::class], "edit.investor_info")]
    public function edit(Request $request, Response $response, array $args): Response
    {
        return $this->runPage($request, $response, $args, "InvestorInfoEdit");
    }

    // delete
    #[Map(["GET","POST","OPTIONS"], "/investorinfodelete[/{id}]", [PermissionMiddleware::class], "delete.investor_info")]
    public function delete(Request $request, Response $response, array $args): Response
    {
        return $this->runPage($request, $response, $args, "InvestorInfoDelete");
    }

    // search
    #[Map(["GET","POST","OPTIONS"], "/investorinfosearch", [PermissionMiddleware::class], "search.investor_info")]
    public function search(Request $request, Response $response, array $args): Response
    {
        return $this->runPage($request, $response, $args, "InvestorInfoSearch");
    }
}
