<?php

namespace PHPMaker2024\fibre;

use Psr\Container\ContainerInterface;
use Psr\Http\Message\ServerRequestInterface as Request;
use Psr\Http\Message\ResponseInterface as Response;
use PHPMaker2024\fibre\Attributes\Delete;
use PHPMaker2024\fibre\Attributes\Get;
use PHPMaker2024\fibre\Attributes\Map;
use PHPMaker2024\fibre\Attributes\Options;
use PHPMaker2024\fibre\Attributes\Patch;
use PHPMaker2024\fibre\Attributes\Post;
use PHPMaker2024\fibre\Attributes\Put;

class IntShopController extends ControllerBase
{
    // list
    #[Map(["GET","POST","OPTIONS"], "/intshoplist[/{id}]", [PermissionMiddleware::class], "list.int_shop")]
    public function list(Request $request, Response $response, array $args): Response
    {
        return $this->runPage($request, $response, $args, "IntShopList");
    }

    // add
    #[Map(["GET","POST","OPTIONS"], "/intshopadd[/{id}]", [PermissionMiddleware::class], "add.int_shop")]
    public function add(Request $request, Response $response, array $args): Response
    {
        return $this->runPage($request, $response, $args, "IntShopAdd");
    }

    // view
    #[Map(["GET","POST","OPTIONS"], "/intshopview[/{id}]", [PermissionMiddleware::class], "view.int_shop")]
    public function view(Request $request, Response $response, array $args): Response
    {
        return $this->runPage($request, $response, $args, "IntShopView");
    }

    // edit
    #[Map(["GET","POST","OPTIONS"], "/intshopedit[/{id}]", [PermissionMiddleware::class], "edit.int_shop")]
    public function edit(Request $request, Response $response, array $args): Response
    {
        return $this->runPage($request, $response, $args, "IntShopEdit");
    }
}
