<?php

namespace PHPMaker2024\fibre;

use Psr\Container\ContainerInterface;
use Psr\Http\Message\ServerRequestInterface as Request;
use Psr\Http\Message\ResponseInterface as Response;
use PHPMaker2024\fibre\Attributes\Delete;
use PHPMaker2024\fibre\Attributes\Get;
use PHPMaker2024\fibre\Attributes\Map;
use PHPMaker2024\fibre\Attributes\Options;
use PHPMaker2024\fibre\Attributes\Patch;
use PHPMaker2024\fibre\Attributes\Post;
use PHPMaker2024\fibre\Attributes\Put;

class IntPortalUpdatesController extends ControllerBase
{
    // list
    #[Map(["GET","POST","OPTIONS"], "/intportalupdateslist[/{id}]", [PermissionMiddleware::class], "list.int_portal_updates")]
    public function list(Request $request, Response $response, array $args): Response
    {
        return $this->runPage($request, $response, $args, "IntPortalUpdatesList");
    }

    // add
    #[Map(["GET","POST","OPTIONS"], "/intportalupdatesadd[/{id}]", [PermissionMiddleware::class], "add.int_portal_updates")]
    public function add(Request $request, Response $response, array $args): Response
    {
        return $this->runPage($request, $response, $args, "IntPortalUpdatesAdd");
    }

    // search
    #[Map(["GET","POST","OPTIONS"], "/intportalupdatessearch", [PermissionMiddleware::class], "search.int_portal_updates")]
    public function search(Request $request, Response $response, array $args): Response
    {
        return $this->runPage($request, $response, $args, "IntPortalUpdatesSearch");
    }
}
