<?php

namespace PHPMaker2024\fibre;

use Psr\Container\ContainerInterface;
use Psr\Http\Message\ServerRequestInterface as Request;
use Psr\Http\Message\ResponseInterface as Response;
use PHPMaker2024\fibre\Attributes\Delete;
use PHPMaker2024\fibre\Attributes\Get;
use PHPMaker2024\fibre\Attributes\Map;
use PHPMaker2024\fibre\Attributes\Options;
use PHPMaker2024\fibre\Attributes\Patch;
use PHPMaker2024\fibre\Attributes\Post;
use PHPMaker2024\fibre\Attributes\Put;

class IntPortalListController extends ControllerBase
{
    // list
    #[Map(["GET","POST","OPTIONS"], "/intportallistlist[/{id}]", [PermissionMiddleware::class], "list.int_portal_list")]
    public function list(Request $request, Response $response, array $args): Response
    {
        return $this->runPage($request, $response, $args, "IntPortalListList");
    }

    // add
    #[Map(["GET","POST","OPTIONS"], "/intportallistadd[/{id}]", [PermissionMiddleware::class], "add.int_portal_list")]
    public function add(Request $request, Response $response, array $args): Response
    {
        return $this->runPage($request, $response, $args, "IntPortalListAdd");
    }

    // view
    #[Map(["GET","POST","OPTIONS"], "/intportallistview[/{id}]", [PermissionMiddleware::class], "view.int_portal_list")]
    public function view(Request $request, Response $response, array $args): Response
    {
        return $this->runPage($request, $response, $args, "IntPortalListView");
    }

    // edit
    #[Map(["GET","POST","OPTIONS"], "/intportallistedit[/{id}]", [PermissionMiddleware::class], "edit.int_portal_list")]
    public function edit(Request $request, Response $response, array $args): Response
    {
        return $this->runPage($request, $response, $args, "IntPortalListEdit");
    }

    // delete
    #[Map(["GET","POST","OPTIONS"], "/intportallistdelete[/{id}]", [PermissionMiddleware::class], "delete.int_portal_list")]
    public function delete(Request $request, Response $response, array $args): Response
    {
        return $this->runPage($request, $response, $args, "IntPortalListDelete");
    }
}
