<?php

namespace PHPMaker2024\fibre;

use Psr\Container\ContainerInterface;
use Psr\Http\Message\ServerRequestInterface as Request;
use Psr\Http\Message\ResponseInterface as Response;
use PHPMaker2024\fibre\Attributes\Delete;
use PHPMaker2024\fibre\Attributes\Get;
use PHPMaker2024\fibre\Attributes\Map;
use PHPMaker2024\fibre\Attributes\Options;
use PHPMaker2024\fibre\Attributes\Patch;
use PHPMaker2024\fibre\Attributes\Post;
use PHPMaker2024\fibre\Attributes\Put;

class IntFibreHelpController extends ControllerBase
{
    // list
    #[Map(["GET","POST","OPTIONS"], "/intfibrehelplist[/{id}]", [PermissionMiddleware::class], "list.int_fibre_help")]
    public function list(Request $request, Response $response, array $args): Response
    {
        return $this->runPage($request, $response, $args, "IntFibreHelpList");
    }

    // edit
    #[Map(["GET","POST","OPTIONS"], "/intfibrehelpedit[/{id}]", [PermissionMiddleware::class], "edit.int_fibre_help")]
    public function edit(Request $request, Response $response, array $args): Response
    {
        return $this->runPage($request, $response, $args, "IntFibreHelpEdit");
    }

    // search
    #[Map(["GET","POST","OPTIONS"], "/intfibrehelpsearch", [PermissionMiddleware::class], "search.int_fibre_help")]
    public function search(Request $request, Response $response, array $args): Response
    {
        return $this->runPage($request, $response, $args, "IntFibreHelpSearch");
    }
}
