<?php

namespace PHPMaker2024\fibre;

use Psr\Container\ContainerInterface;
use Psr\Http\Message\ServerRequestInterface as Request;
use Psr\Http\Message\ResponseInterface as Response;
use PHPMaker2024\fibre\Attributes\Delete;
use PHPMaker2024\fibre\Attributes\Get;
use PHPMaker2024\fibre\Attributes\Map;
use PHPMaker2024\fibre\Attributes\Options;
use PHPMaker2024\fibre\Attributes\Patch;
use PHPMaker2024\fibre\Attributes\Post;
use PHPMaker2024\fibre\Attributes\Put;

class IntFibreApcGrpController extends ControllerBase
{
    // list
    #[Map(["GET","POST","OPTIONS"], "/intfibreapcgrplist[/{id}]", [PermissionMiddleware::class], "list.int_fibre_apc_grp")]
    public function list(Request $request, Response $response, array $args): Response
    {
        return $this->runPage($request, $response, $args, "IntFibreApcGrpList");
    }

    // add
    #[Map(["GET","POST","OPTIONS"], "/intfibreapcgrpadd[/{id}]", [PermissionMiddleware::class], "add.int_fibre_apc_grp")]
    public function add(Request $request, Response $response, array $args): Response
    {
        return $this->runPage($request, $response, $args, "IntFibreApcGrpAdd");
    }

    // addopt
    #[Map(["GET","POST","OPTIONS"], "/intfibreapcgrpaddopt", [PermissionMiddleware::class], "addopt.int_fibre_apc_grp")]
    public function addopt(Request $request, Response $response, array $args): Response
    {
        return $this->runPage($request, $response, $args, "IntFibreApcGrpAddopt", null, false);
    }

    // view
    #[Map(["GET","POST","OPTIONS"], "/intfibreapcgrpview[/{id}]", [PermissionMiddleware::class], "view.int_fibre_apc_grp")]
    public function view(Request $request, Response $response, array $args): Response
    {
        return $this->runPage($request, $response, $args, "IntFibreApcGrpView");
    }

    // edit
    #[Map(["GET","POST","OPTIONS"], "/intfibreapcgrpedit[/{id}]", [PermissionMiddleware::class], "edit.int_fibre_apc_grp")]
    public function edit(Request $request, Response $response, array $args): Response
    {
        return $this->runPage($request, $response, $args, "IntFibreApcGrpEdit");
    }

    // delete
    #[Map(["GET","POST","OPTIONS"], "/intfibreapcgrpdelete[/{id}]", [PermissionMiddleware::class], "delete.int_fibre_apc_grp")]
    public function delete(Request $request, Response $response, array $args): Response
    {
        return $this->runPage($request, $response, $args, "IntFibreApcGrpDelete");
    }
}
