<?php

namespace PHPMaker2024\fibre;

use Psr\Container\ContainerInterface;
use Psr\Http\Message\ServerRequestInterface as Request;
use Psr\Http\Message\ResponseInterface as Response;
use PHPMaker2024\fibre\Attributes\Delete;
use PHPMaker2024\fibre\Attributes\Get;
use PHPMaker2024\fibre\Attributes\Map;
use PHPMaker2024\fibre\Attributes\Options;
use PHPMaker2024\fibre\Attributes\Patch;
use PHPMaker2024\fibre\Attributes\Post;
use PHPMaker2024\fibre\Attributes\Put;

class IncotermController extends ControllerBase
{
    // list
    #[Map(["GET","POST","OPTIONS"], "/incotermlist[/{id}]", [PermissionMiddleware::class], "list.incoterm")]
    public function list(Request $request, Response $response, array $args): Response
    {
        return $this->runPage($request, $response, $args, "IncotermList");
    }

    // add
    #[Map(["GET","POST","OPTIONS"], "/incotermadd[/{id}]", [PermissionMiddleware::class], "add.incoterm")]
    public function add(Request $request, Response $response, array $args): Response
    {
        return $this->runPage($request, $response, $args, "IncotermAdd");
    }

    // addopt
    #[Map(["GET","POST","OPTIONS"], "/incotermaddopt", [PermissionMiddleware::class], "addopt.incoterm")]
    public function addopt(Request $request, Response $response, array $args): Response
    {
        return $this->runPage($request, $response, $args, "IncotermAddopt", null, false);
    }

    // view
    #[Map(["GET","POST","OPTIONS"], "/incotermview[/{id}]", [PermissionMiddleware::class], "view.incoterm")]
    public function view(Request $request, Response $response, array $args): Response
    {
        return $this->runPage($request, $response, $args, "IncotermView");
    }

    // edit
    #[Map(["GET","POST","OPTIONS"], "/incotermedit[/{id}]", [PermissionMiddleware::class], "edit.incoterm")]
    public function edit(Request $request, Response $response, array $args): Response
    {
        return $this->runPage($request, $response, $args, "IncotermEdit");
    }

    // delete
    #[Map(["GET","POST","OPTIONS"], "/incotermdelete[/{id}]", [PermissionMiddleware::class], "delete.incoterm")]
    public function delete(Request $request, Response $response, array $args): Response
    {
        return $this->runPage($request, $response, $args, "IncotermDelete");
    }
}
