<?php

namespace PHPMaker2024\fibre;

use Psr\Container\ContainerInterface;
use Psr\Http\Message\ServerRequestInterface as Request;
use Psr\Http\Message\ResponseInterface as Response;
use PHPMaker2024\fibre\Attributes\Delete;
use PHPMaker2024\fibre\Attributes\Get;
use PHPMaker2024\fibre\Attributes\Map;
use PHPMaker2024\fibre\Attributes\Options;
use PHPMaker2024\fibre\Attributes\Patch;
use PHPMaker2024\fibre\Attributes\Post;
use PHPMaker2024\fibre\Attributes\Put;

class ImporterController extends ControllerBase
{
    // list
    #[Map(["GET","POST","OPTIONS"], "/importerlist[/{id}]", [PermissionMiddleware::class], "list.importer")]
    public function list(Request $request, Response $response, array $args): Response
    {
        return $this->runPage($request, $response, $args, "ImporterList");
    }

    // add
    #[Map(["GET","POST","OPTIONS"], "/importeradd[/{id}]", [PermissionMiddleware::class], "add.importer")]
    public function add(Request $request, Response $response, array $args): Response
    {
        return $this->runPage($request, $response, $args, "ImporterAdd");
    }

    // addopt
    #[Map(["GET","POST","OPTIONS"], "/importeraddopt", [PermissionMiddleware::class], "addopt.importer")]
    public function addopt(Request $request, Response $response, array $args): Response
    {
        return $this->runPage($request, $response, $args, "ImporterAddopt", null, false);
    }

    // view
    #[Map(["GET","POST","OPTIONS"], "/importerview[/{id}]", [PermissionMiddleware::class], "view.importer")]
    public function view(Request $request, Response $response, array $args): Response
    {
        return $this->runPage($request, $response, $args, "ImporterView");
    }

    // edit
    #[Map(["GET","POST","OPTIONS"], "/importeredit[/{id}]", [PermissionMiddleware::class], "edit.importer")]
    public function edit(Request $request, Response $response, array $args): Response
    {
        return $this->runPage($request, $response, $args, "ImporterEdit");
    }

    // delete
    #[Map(["GET","POST","OPTIONS"], "/importerdelete[/{id}]", [PermissionMiddleware::class], "delete.importer")]
    public function delete(Request $request, Response $response, array $args): Response
    {
        return $this->runPage($request, $response, $args, "ImporterDelete");
    }
}
