<?php

namespace PHPMaker2024\fibre;

use Psr\Container\ContainerInterface;
use Psr\Http\Message\ServerRequestInterface as Request;
use Psr\Http\Message\ResponseInterface as Response;
use PHPMaker2024\fibre\Attributes\Delete;
use PHPMaker2024\fibre\Attributes\Get;
use PHPMaker2024\fibre\Attributes\Map;
use PHPMaker2024\fibre\Attributes\Options;
use PHPMaker2024\fibre\Attributes\Patch;
use PHPMaker2024\fibre\Attributes\Post;
use PHPMaker2024\fibre\Attributes\Put;

class ImportBcodeController extends ControllerBase
{
    // list
    #[Map(["GET","POST","OPTIONS"], "/importbcodelist[/{id}]", [PermissionMiddleware::class], "list.import_bcode")]
    public function list(Request $request, Response $response, array $args): Response
    {
        return $this->runPage($request, $response, $args, "ImportBcodeList");
    }

    // add
    #[Map(["GET","POST","OPTIONS"], "/importbcodeadd[/{id}]", [PermissionMiddleware::class], "add.import_bcode")]
    public function add(Request $request, Response $response, array $args): Response
    {
        return $this->runPage($request, $response, $args, "ImportBcodeAdd");
    }
}
