<?php

namespace PHPMaker2024\fibre;

use Psr\Container\ContainerInterface;
use Psr\Http\Message\ServerRequestInterface as Request;
use Psr\Http\Message\ResponseInterface as Response;
use PHPMaker2024\fibre\Attributes\Delete;
use PHPMaker2024\fibre\Attributes\Get;
use PHPMaker2024\fibre\Attributes\Map;
use PHPMaker2024\fibre\Attributes\Options;
use PHPMaker2024\fibre\Attributes\Patch;
use PHPMaker2024\fibre\Attributes\Post;
use PHPMaker2024\fibre\Attributes\Put;

class HelpController extends ControllerBase
{
    // list
    #[Map(["GET","POST","OPTIONS"], "/helplist[/{id}]", [PermissionMiddleware::class], "list.help")]
    public function list(Request $request, Response $response, array $args): Response
    {
        return $this->runPage($request, $response, $args, "HelpList");
    }

    // edit
    #[Map(["GET","POST","OPTIONS"], "/helpedit[/{id}]", [PermissionMiddleware::class], "edit.help")]
    public function edit(Request $request, Response $response, array $args): Response
    {
        return $this->runPage($request, $response, $args, "HelpEdit");
    }

    // update
    #[Map(["GET","POST","OPTIONS"], "/helpupdate", [PermissionMiddleware::class], "update.help")]
    public function update(Request $request, Response $response, array $args): Response
    {
        return $this->runPage($request, $response, $args, "HelpUpdate");
    }

    // search
    #[Map(["GET","POST","OPTIONS"], "/helpsearch", [PermissionMiddleware::class], "search.help")]
    public function search(Request $request, Response $response, array $args): Response
    {
        return $this->runPage($request, $response, $args, "HelpSearch");
    }
}
